% Before you run this test script make sure the MEX executables are built in the 
% tsp_cuda/matlab directory.  Within MATLAB, move into the directory tsp_cuda/matlab
% and type 'make' to build the executables.

% Add the path to the matlab executables
addpath('../matlab');

% Load the GIST/LMS test data
A = importdata('GIST_LMS_small.csv');

disp('Running TSP with no filtering for differentially expressed genes');

% Run the TSP algorithm
% The [] tells the algorithm to look in the 1st row for class information
% The A.rowheaders(2:end) passes in the probe names, skipping the first 'ID' column
[result] = tsp_cuda(A.data, [], A.rowheaders(2:end));

% Classify the result
[classifiers] = classify_cuda(result);

% Print the classifiers to the screen
classifiers(1)

% Cross validate the result, and find the error rate
[error_rate, predictions] = cv_cuda(classifiers, A.data);

% Print error rate
fprintf('Error rate for classifier is %.3f\n', error_rate);

disp('Running TSP with filtering for top 100 differentially expressed genes');

% Run the TSP algorithm
% The [] tells the algorithm to look in the 1st row for class information
% The A.rowheaders(2:end) passes in the probe names, skipping the first 'ID' column
% The 1 is ignored, and the 100 tells the program to filter for top 100 differentially expressed genes
[result] = tsp_cuda(A.data, [], A.rowheaders(2:end), 100);

% Classify the result
[classifiers] = classify_cuda(result);

% Print the classifiers to the screen
classifiers(1)

% Cross validate the result, and find the error rate
[error_rate, predictions] = cv_cuda(classifiers, A.data);

% Print error rate
fprintf('Error rate for classifier is %.4f\n', error_rate);

disp('Running kTSP on all genes')

% Run the kTSP algorithm on all genes with max K = 10
[result] = ktsp_cuda(A.data, [], A.rowheaders(2:end), 10);

% Classify the result
[classifiers] = classify_cuda(result);

% Print the classifiers to the screen
classifiers

% Cross validate the result, and find the error rate
[error_rate, predictions] = cv_cuda(classifiers, A.data);

% Print error rate
fprintf('Error rate for classifier is %.3f\n', error_rate);

disp('Running TST on top 500 differentially expressed genes');

% Run the TST algorithm on top 500 differentially expressed genes
[classifiers] = tst_cuda(A.data, [], A.rowheaders(2:end), 500);

% Print the classifiers to the screen
classifiers
