%=================================================================
%
%  make.m
%  Author: Andrew Magis
%  Makefile for the MATLAB installation of tsp_cuda
%=================================================================

% Check the locations below to ensure they match your system configuration!
% Change the CUDA_Compiler_Location and CUDA_LIB_Location to match your system

% This portion taken from nvmex.m from 2009 The MathWorks, Inc.
if ispc % Windows
    CUDA_Compiler_Location = 'C:\CUDA\bin\nvcc';
    CUDA_LIB_Location = 'C:\CUDA\lib';
    Host_Compiler_Location = '-ccbin "C:\Program Files\Microsoft Visual Studio 9.0\VC\bin"';
    PIC_Option = '--gpu-architecture compute_11 --gpu-code sm_11,sm_12,sm_13,sm_20 ';
else % Mac and Linux (assuming gcc is on the path)
    CUDA_Compiler_Location = '/usr/local/cuda/bin/nvcc';
    CUDA_LIB_Location = '/usr/local/cuda/lib64/';
    Host_Compiler_Location = '';
    PIC_Option = '--gpu-architecture compute_11 --gpu-code sm_11,sm_12,sm_13,sm_20  --compiler-options -fPIC ';
end
% End MathWorks code

%%%%%%%%%%%%% END EDIT SECTION!  DO NOT MODIFY BELOW! %%%%%%%%%%%%%%%%%%%%%%

% Build the c++ codes first
fprintf('Building the *.cpp files\n');
mex tiedrankmex.cpp
mex ranksummex.cpp
mex loocvmex.cpp

fprintf('Building the CUDA *.cu files\n')
fprintf('If this does not work, ensure the paths to the CUDA libraries \nand NVCC compiler are correct in make.m!\n\n\n');

nvmex('nvtspmex.cu', CUDA_Compiler_Location, CUDA_LIB_Location, Host_Compiler_Location, PIC_Option);
nvmex('nvtstmex.cu', CUDA_Compiler_Location, CUDA_LIB_Location, Host_Compiler_Location, PIC_Option);
nvmex('nvtstmemmex.cu',  CUDA_Compiler_Location, CUDA_LIB_Location, Host_Compiler_Location, PIC_Option);
nvmex('nvdisjointpairmex.cu', CUDA_Compiler_Location, CUDA_LIB_Location, Host_Compiler_Location, PIC_Option);

fprintf('Deleting object files\n');
delete *.o
fprintf('Finished building tsp_cuda\n')
fprintf('Above MATLAB warnings about source files and 32-bit compatibility are typical\n');
