/*=================================================================
 *
 *  Exception.h
 *  Author: Andrew Magis
 *  Defines exception functions
 *
 *=================================================================*/

#ifndef _EXCEPTION_H
#define	_EXCEPTION_H

#include <string>
#include <stdlib.h>
#include <exception>

using std::exception;
using std::string;

class GeneralException : public exception {
public:
    GeneralException() throw() : message("General Exception") {};
    GeneralException(string _message) throw() : message(_message) {};
    virtual ~GeneralException() throw() {};
    GeneralException(string _message, string _class) throw() {

        //Generate complete error message including throwing class name:
        message = _message;
        message.append(" <");
        message.append(_class);
        message.append(">");

    };
    GeneralException(string _message, string _value, string _class) throw() {

        //Generate complete error message including throwing class name:
        message = _message;
        message.append(": ");
        message.append(_value);
        message.append(" <");
        message.append(_class);
        message.append(">");

    };

    //Overload this function for a more detailed message
    virtual const char* what() const throw() {
        return message.c_str();
    }

private:
    string message;

};


#endif	/* _EXCEPTION_H */

