/*=================================================================
 *
 *  TiedRank.h
 *  Author: Andrew Magis
 *  Calculate tiedrank on vector of data. Output vector is
 *  passed in by reference.  All tiedranks are averaged.
 *
 *=================================================================*/

#ifndef _TIEDRANK_H
#define _TIEDRANK_H

#include "TiedRank_base.h"
#include <vector>

float* TiedRank(float *data, unsigned int m1, unsigned int n1) { 
				
	// Create an array for the output data
	float *output = new float[m1*n1];
	std::vector< std::pair<float, int> > wilcox_scores;
	
	//Main loop, looping over every column
	for (int i = 0; i < n1; i++) {
	
		std::vector<float> col(m1, 0);
		std::vector<float> ranks(m1, 0);
	
		//Copy the elements of this column into a vector
		for (int j = 0; j < m1; j++) {
			col[j] = data[m1*i+j];
		}
		
		//Pass the two vectors to tiedrank to calculate ranks
		tiedrank(col, ranks); 
		
		//Finally, put the ranks into the output matrix using the original indices
		for (int j = 0; j < m1; j++) {
			output[m1*i+j] = ranks[j];
		}
	}
	return output;
}

#endif
