% function [R_1,R_2,T_train] = rank_matching_practice(X,g_gs_idx)

X = gs_struct.X;
g_gs_idx = gs_struct.g_gs_idx;

M = size(g_gs_idx,1); % M is the total number of networks, or pathways
N = size(X,2); % N is samples

N_1 = sum(groups); 
N_2 = sum(~groups);

% R_1 = zeros(M,N); R_2 = zeros(M,N);

T_train = struct('T_1',{},'T_2',{}); % group orderings (rank templates)
% for m = 1:M
m = 164;
    g_m = g_gs_idx(m,g_gs_idx(m,:)>0);
    G_m = numel(g_m);
    
    G_m_choose_2 = G_m*(G_m-1)/2;
    T_0 = nchoosek(1:G_m,2);
    
    X_m = X(g_m,:); % Pull out rows in X corresponding to current group
    
    %*
    pair_first = T_0(:,1);
    pair_second = T_0(:,2);
    
    X_m_pair_first = X_m(pair_first,:);
    X_m_pair_second = X_m(pair_second,:);
    
    X_m_p1_1 = X_m_pair_first(:,groups);
    X_m_p2_1 = X_m_pair_second(:,groups);
    
    X_m_p1_2 = X_m_pair_first(:,~groups);
    X_m_p2_2 = X_m_pair_second(:,~groups);
    
    compare_1 = X_m_p1_1 < X_m_p2_1;
    num_lessthan = sum(compare_1,2);
    perc_lessthan = num_lessthan/N_1;
    
    T_1 = perc_lessthan > 0.5;
    
    compare_2 = X_m_p1_2 < X_m_p2_2;
    num_lessthan = sum(compare_2,2);
    perc_lessthan = num_lessthan/N_2;
    
    T_2 = perc_lessthan > 0.5;
    
%     T_1 = (sum(X_m(T_0(:,1),groups) < X_m(T_0(:,2),groups),2)/N_1)>0.5;
%     T_2 = (sum(X_m(T_0(:,1),~groups) < X_m(T_0(:,2),~groups),2)/N_2)>0.5;

    T_train(m).T_1 = T_1; T_train(m).T_2 = T_2;
    
    %*
    Z = X_m_pair_first < X_m_pair_second;
%     Z = X_m(T_0(:,1),:) < X_m(T_0(:,2),:);
    
    %*
    T_1_mat = repmat(T_1,1,N);
    compare_Z_T_1 = Z == T_1_mat;
    num_match = sum(compare_Z_T_1);
    R_1 = num_match/G_m_choose_2;
    
%     R_1(m,:) = sum(Z == repmat(T_1,1,N),1)/G_m_choose_2;

%*     R_1 = sum(Z == repmat(T_1,1,N),1)/G_m_choose_2;
    
    %*
    T_2_mat = repmat(T_2,1,N);
    compare_Z_T_2 = Z == T_2_mat;
    num_match = sum(compare_Z_T_2);
    R_2 = num_match/G_m_choose_2;
    
%     R_2(m,:) = sum(Z == repmat(T_2,1,N),1)/G_m_choose_2;

%*     R_2 = sum(Z == repmat(T_2,1,N),1)/G_m_choose_2;
% end
